-module(emqx_auth_anonymous).

-include_lib("emqx/include/emqx.hrl").

-export([ load/0, unload/0 ]).

-export([ on_client_authenticate/2 ]).

load() ->
    emqx:hook('client.authenticate', {?MODULE, on_client_authenticate, []}).

on_client_authenticate(#{username := Username, password := Password}, AuthResult) ->
    if
        (Username == undefined) and (Password == undefined) ->
            {stop, AuthResult#{username => <<"anonymous">>, auth_result => success, anonymous => false}};
        true ->
            {ok, AuthResult}
    end.

unload() ->
    emqx:unhook('client.authenticate', {?MODULE, on_client_authenticate}).

