-module(emqx_auth_anonymous_app).

-behaviour(application).
-behaviour(supervisor).

-emqx_plugin(?MODULE).

-export([start/2, stop/1]).
-export([init/1]).

start(_Type, _Args) ->
    emqx:hook('client.authenticate', fun emqx_auth_anonymous:check/2),
    supervisor:start_link({local, ?MODULE}, ?MODULE, []).

stop(_State) ->
    emqx:unhook('client.authenticate', fun emqx_auth_anonymous:check/2).

%%--------------------------------------------------------------------

init([]) ->
    {ok, { {one_for_all, 1, 10}, []} }.

